<?php defined('SYSPATH') or die('No direct script access.');

// -- Environment setup --------------------------------------------------------

// Load the core Kohana class
require SYSPATH.'classes/kohana/core'.EXT;

if (is_file(APPPATH.'classes/kohana'.EXT))
{
	// Application extends the core
	require APPPATH.'classes/kohana'.EXT;
}
else
{
	// Load empty core extension
	require SYSPATH.'classes/kohana'.EXT;
}

/**
 * Set the default time zone.
 *
 * @see  http://kohanaframework.org/guide/using.configuration
 * @see  http://php.net/timezones
 */
date_default_timezone_set('Africa/Algiers');

/**
 * Set the default locale.
 *
 * @see  http://kohanaframework.org/guide/using.configuration
 * @see  http://php.net/setlocale
 */
setlocale(LC_ALL, 'en_US.utf-8');

/**
 * Enable the Kohana auto-loader.
 *
 * @see  http://kohanaframework.org/guide/using.autoloading
 * @see  http://php.net/spl_autoload_register
 */
spl_autoload_register(array('Kohana', 'auto_load'));

/**
 * Enable the Kohana auto-loader for unserialization.
 *
 * @see  http://php.net/spl_autoload_call
 * @see  http://php.net/manual/var.configuration.php#unserialize-callback-func
 */
ini_set('unserialize_callback_func', 'spl_autoload_call');

// -- Configuration and initialization -----------------------------------------

/**
 * Set the default language
 */
I18n::lang('en-us');

/**
 * Set Kohana::$environment if a 'KOHANA_ENV' environment variable has been supplied.
 *
 * Note: If you supply an invalid environment name, a PHP warning will be thrown
 * saying "Couldn't find constant Kohana::<INVALID_ENV_NAME>"
 */
 Kohana::$environment = Kohana::PRODUCTION;
 error_reporting(E_ALL ^ E_NOTICE ^ E_STRICT);
 
if (isset($_SERVER['KOHANA_ENV']))
{
	Kohana::$environment = constant('Kohana::'.strtoupper($_SERVER['KOHANA_ENV']));
}


/**
 * Turn errors into exceptions. 
 */
Kohana::$errors = true;

/**
 * Custom exception handler.
 */
restore_exception_handler();
set_exception_handler(array('Exception_Handler', 'handler'));

/**
 * Initialize Kohana, setting the default options.
 *
 * The following options are available:
 *
 * - string   base_url    path, and optionally domain, of your application   NULL
 * - string   index_file  name of your index file, usually "index.php"       index.php
 * - string   charset     internal character set used for input and output   utf-8
 * - string   cache_dir   set the internal cache directory                   APPPATH/cache
 * - boolean  errors      enable or disable error handling                   TRUE
 * - boolean  profile     enable or disable internal profiling               TRUE
 * - boolean  caching     enable or disable internal caching                 FALSE
 */

Kohana::init(array(
'base_url' => '/',
'index_file' => ''
));
/**
 * Attach the file write to logging. Multiple writers are supported.
 */
Kohana::$log->attach(new Log_File(APPPATH.'logs'));

/**
 * Attach a file reader to config. Multiple readers are supported.
 */
Kohana::$config->attach(new Config_File);

/**
 * Enable modules. Modules are referenced by a relative or absolute path.
 */
Kohana::modules(array(
    //'user' => MODPATH.'user',
	'auth'       => MODPATH.'auth',       // Basic authentication
	// 'cache'      => MODPATH.'cache',      // Caching with multiple backends
	// 'codebench'  => MODPATH.'codebench',  // Benchmarking tool
	'database'   => MODPATH.'database',   // Database access
	// 'image'      => MODPATH.'image',      // Image manipulation
	'orm'        => MODPATH.'orm',        // Object Relationship Mapping
	// 'unittest'   => MODPATH.'unittest',   // Unit testing
	 'userguide'  => MODPATH.'userguide',  // User guide and API documentation
	'pagination' 	 => MODPATH.'pagination',
	'email' 	 => MODPATH.'kohana-email',
	//'error'         => MODPATH.'error',

	));

/**
 * Cookie salt for remember user info
 */
 Cookie::$salt = 'fdsh-tretgd-re-gfds-gt-erg-fdg-';
/**
 * Set the routes. Each route must have a minimum of a name, a URI and a set of
 * defaults for the URI.
 */

 
Route::set('page', 'page/produits/<categorie>((/<famille>(/<sousfamille>)))')
->defaults(array(	
'controller' => 'page',
'action' => 'produits',
));



Route::set('page/ajouterarticle', 'page/ajouterarticle/<id>/<quantite>/<lien>')
->defaults(array(	
'controller' => 'page',
'action' => 'ajouterarticle',
));

Route::set('page/modifierarticle', 'page/modifierarticle/<id>/<quantite>')
->defaults(array(	
'controller' => 'page',
'action' => 'modifierarticle',
));

Route::set('page/supprimerarticle', 'page/supprimerarticle/<id>')
->defaults(array(	
'controller' => 'page',
'action' => 'supprimerarticle',
));

Route::set('page/detail', 'page/detail/<id>')
->defaults(array(	
'controller' => 'page',
'action' => 'detail',
));

Route::set('gestioncommandes/supprimercommande', 'gestioncommandes/supprimercommande/<id>')
->defaults(array(	
'controller' => 'gestioncommandes',
'action' => 'supprimercommande',
));

Route::set('gestioncommandes/detailscommande', 'gestioncommandes/detailscommande/<id>/<date>/<montant>')
->defaults(array(	
'controller' => 'gestioncommandes',
'action' => 'detailscommande',
));

Route::set('admin/modifierslider', 'admin/modifierslider/<id>(/<libelle>/<image>)')
->defaults(array(	
'controller' => 'admin',
'action' => 'modifierslider',
));

Route::set('admin/supprimerslider', 'admin/supprimerslider/<id>(/<libelle>/<image>)')
->defaults(array(	
'controller' => 'admin',
'action' => 'supprimerslider',
));

Route::set('admin/modifierarticle', 'admin/modifierarticle/<id>(/<libelle>/<image>)')
->defaults(array(	
'controller' => 'admin',
'action' => 'modifierarticle',
));

Route::set('admin/supprimerarticle', 'admin/supprimerarticle/<id>(/<libelle>/<image>)')
->defaults(array(	
'controller' => 'admin',
'action' => 'modifierarticle',
));

Route::set('admin/modifierproduit', 'admin/modifierproduit/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'modifierproduit',
));

Route::set('admin/ajouterproduit', 'admin/ajouterproduit/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'ajouterproduit',
));

Route::set('admin/supprimerproduit', 'admin/supprimerproduit/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'supprimerproduit',
));

Route::set('admin/listeproduitsagregal', 'admin/listeproduitsagregal/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'listeproduitsagregal',
));

Route::set('admin/modifieruser', 'admin/modifieruser/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'modifieruser',
));

Route::set('admin/ajouteruser', 'admin/ajouteruser/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'ajouteruser',
));

Route::set('admin/supprimeruser', 'admin/supprimeruser/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'supprimeruser',
));

Route::set('user/create', 'user/create/<id>')
->defaults(array(	
'controller' => 'user',
'action' => 'create',
));

Route::set('user/login', 'user/login/<id>')
->defaults(array(	
'controller' => 'user',
'action' => 'login',
));

Route::set('admin/loginuser', 'admin/loginuser/<username>/<password>')
->defaults(array(	
'controller' => 'admin',
'action' => 'loginuser',
));


Route::set('admin/modifieradmin', 'admin/modifieradmin/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'modifieradmin',
));

Route::set('admin/supprimeradmin', 'admin/supprimeradmin/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'supprimeradmin',
));


Route::set('admin/modifiercommande', 'admin/modifiercommande/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'modifiercommande',
));

Route::set('admin/ajoutercommande', 'admin/ajoutercommande/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'ajoutercommande',
));

Route::set('admin/supprimercommande', 'admin/supprimercommande/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'supprimercommande',
));

Route::set('admin/listecommandes', 'admin/listecommandes/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'listecommandes',
));

Route::set('admin/validercommande', 'admin/validercommande/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'validercommande',
));

Route::set('admin/devalidercommande', 'admin/devalidercommande/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'devalidercommande',
));

Route::set('admin/modifierpartenaire', 'admin/modifierpartenaire/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'modifierpartenaire',
));

Route::set('admin/ajouterpartenaire', 'admin/ajouterpartenaire/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'ajouterpartenaire',
));

Route::set('admin/supprimerpartenaire', 'admin/supprimerpartenaire/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'supprimerpartenaire',
));

Route::set('admin/listepartenaires', 'admin/listepartenaires/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'listepartenaires',
));

Route::set('admin/modifierpromotion', 'admin/modifierpromotion/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'modifierpromotion',
));

Route::set('admin/ajouterpromotion', 'admin/ajouterpromotion/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'ajouterpromotion',
));

Route::set('admin/supprimerpromotion', 'admin/supprimerpromotion/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'supprimerpromotion',
));

Route::set('admin/listepromotions', 'admin/listepromotions/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'listepromotions',
));

Route::set('admin/login', 'admin/login/<id>')
->defaults(array(	
'controller' => 'admin',
'action' => 'login',
));

Route::set('admin', 'admin(/<action>(/<id>/<id2>))')
->defaults(array(	
'controller' => 'admin',
'action' => 'index',
));

Route::set('default', '(<controller>(/<action>(/<id>/<id2>)))')
	->defaults(array(
		'controller' => 'page',
		'action'     => 'index',
	));

Route::set('error', 'error/<action>/(<message>)', array('action' => '[0-9]++', 'message' => '.+'))
    ->defaults(array(
        'controller' => 'error',
        'action'     => '404'
));