<?php defined('SYSPATH') OR die('No direct access allowed.');

class Controller_Album extends Controller_Applications
{
	public $template = 'templates';
	 private $album_model;
	 private $genre_model;

	 private $list_view;
	 private $create_view;
	 private $update_view;

	

 	public function action_index()
 	{
 		$this->album_model   = Model::factory( 'Album');
		$this->genre_model  	= Model::factory('Album') ;
	  	$this->list_view   	=  View::factory('list');
	  	//$this->update_view  	=  View::factory('update');
	  //	$this->create_view  	=  View::factory('create');
  		$this->show_albums_list();
 	}

	private function show_albums_list()
	{
		$albums_list = $this->album_model->get_list();
		$this->list_view->set('albums_list',$albums_list);
	
$this->template->content = $this->list_view;
		
	}

 	public function show_create_editor()
 	{
 		$this->create_view->set('genres_list',$this->get_genres_list());
  		$this->create_view->render(TRUE);
 	}

 	public function show_update_editor($id)
 	{
		$album_data = $this->album_model->read($id);
		$this->update_view->set('album_id',$album_data[0]->id);
		$this->update_view->set('name',$album_data[0]->name);
		$this->update_view->set('author',$album_data[0]->author);
		$this->update_view->set('genre_id',$album_data[0]->genre_id);
		$this->update_view->set('genres_list',$this->get_genres_list());
		$this->update_view->render(TRUE);
 	}

 	public function create()
 	{
		$album_data=array(
		'name'    	=> $this->input->post('name'),
		'author'  	=> $this->input->post('author'),
		'genre_id'  => $this->input->post('genre_id')
		);
		$this->album_model->create($album_data);
		url::redirect('album');
 	}

	public function update()
	{
		$album_data = array(
			'name'    	=> $this->input->post('name'),
			'author'  	=> $this->input->post('author'),
			'genre_id'  => $this->input->post('genre_id')
		);
		$this->album_model->update($this->input->post('album_id'),$album_data);
  		url::redirect('album');
 	}

  	public function delete($id)
 	{
		$this->album_model->delete($id);
		url::redirect('album');
 	}

	private function get_genres_list()
	{
		$db_genres_list  = $this->genre_model->get_list();
		$genres_list  = array();

		if(sizeof($db_genres_list) >= 1)
		{
			foreach($db_genres_list as $item)
			{
				$genres_list[$item->id] = $item->name;
			}
		}
		return $genres_list;
 	}
}
