<?php defined('SYSPATH') or die('No direct script access.');
class Controller_User extends Controller_Applicationadmin {
public $template = 'templateadmin';	

	public function action_index()
	{
		$this->template->content = View::factory('admin/info')
		    ->bind('nom_site', $nom_site)
			->bind('user', $user);

		// Load the user information 	
		$user = Auth::instance()->get_user();

		// if a user is not logged in, redirect to login page 		
		if (!$user)
		{
			Request::current()->redirect('user/login');
		}
	}

	public function action_create()
	{
		$this->template->content = View::factory('admin/editformuser')
		    ->bind('nom_site', $nom_site)
			->bind('errors', $errors)
			->bind('username', $username)
			->bind('email', $email)
			->bind('isuser', $isuser)
			->bind('raison_sociale', $raison_sociale)
			->bind('telephone', $telephone)
			->bind('nom_contact', $nom_contact)
			->bind('adresse', $adresse)
			->bind('id', $id)
			->bind('message', $message);

		if (HTTP_Request::POST == $this->request->method())
		{
			try {
			    
			     $username=$_POST['username'];
			     $email=$_POST['email'];
			     $isuser=$_POST['isuser'];
			     $raison_sociale=$_POST['raison_sociale'];
			     $telephone=$_POST['telephone'];
			     $nom_contact=$_POST['nom_contact'];
			     $adresse=$_POST['adresse'];
			     

				// Create the user using form values 				
				$user = ORM::factory('user')->create_user($this->request->post(), array(
					'username',
					'password',
					'email',
					'raison_sociale',
					'telephone',
					'nom_contact',
					'adresse'
				));
				
				$id=$user;
               
				// Grant user login role 			
				$user->add('roles', ORM::factory('role', array('name' => 'login')));

				// Reset values so form is not sticky 				
				$_POST = array();

				// Set success message 			
				$message = "Vous avez ajouté l'utilisateur ({$user->username}) à la base de données.";

			} catch (ORM_Validation_Exception $e) {

				// Set failure message 			
				$message = 'Il y a eu des erreurs, veuillez consulter le formulaire ci-dessous.';

				// Set errors using custom messages 			
				$errors = $e->errors('models');
			}
		}
	}


	public function action_update()
	{
		$this->template->content = View::factory('admin/editformuser')
		    ->bind('nom_site', $nom_site)
			->bind('errors', $errors)
			->bind('username', $username)
			->bind('email', $email)
			->bind('isuser', $isuser)
			->bind('raison_sociale', $raison_sociale)
			->bind('telephone', $telephone)
			->bind('nom_contact', $nom_contact)
			->bind('adresse', $adresse)
			->bind('id', $id)
			->bind('message', $message);

		if (HTTP_Request::POST == $this->request->method())
		{
			try {
			    
			    $username=$_POST['username'];
			     $email=$_POST['email'];
			     $isuser=$_POST['isuser'];
			     $raison_sociale=$_POST['raison_sociale'];
			     $telephone=$_POST['telephone'];
			     $nom_contact=$_POST['nom_contact'];
			     $adresse=$_POST['adresse'];
			     $id=$_POST['id'];
			     
                $user = ORM::factory('user')
                  ->where('id', '=', $_POST['id'])
                  ->find()->update_user($this->request->post(), array(
                    'username',
					'password',
					'email',
					'raison_sociale',
					'telephone',
					'nom_contact',
					'adresse'
));
			

				// Grant user login role 			
			//	$user->add('roles', ORM::factory('role', array('name' => 'login'//)));

				// Reset values so form is not sticky 				
				$_POST = array();

				// Set success message 			
				$message = "Vous avez modifier l'utilisateur ({$user->username}) .";

			} catch (ORM_Validation_Exception $e) {

				// Set failure message 			
				$message = 'Il y a eu des erreurs, veuillez consulter le formulaire ci-dessous.';

				// Set errors using custom messages 			
				$errors = $e->errors('models');
			}
		}
	}


// Gestion des administrateurs


	public function action_createadmin()
	{
		$this->template->content = View::factory('admin/editformadmin')
		    ->bind('nom_site', $nom_site)
			->bind('errors', $errors)
			->bind('username', $username)
			->bind('email', $email)
			->bind('isuser', $isuser)
			->bind('id', $id)
			->bind('message', $message);

		if (HTTP_Request::POST == $this->request->method())
		{
			try {
			    
			     $username=$_POST['username'];
			     $email=$_POST['email'];
			     $isuser=$_POST['isuser'];

			     

				// Create the user using form values 				
				$user = ORM::factory('user')->create_user($this->request->post(), array(
					'username',
					'password',
					'isuser',
					'email'
				));
				
				$id=$user;
               
				// Grant user login role 			
				$user->add('roles', ORM::factory('role', array('name' => 'login')));

				// Reset values so form is not sticky 				
				$_POST = array();

				// Set success message 			
				$message = "Vous avez ajouté l'utilisateur ({$user->username}) à la base de données.";

			} catch (ORM_Validation_Exception $e) {

				// Set failure message 			
				$message = 'Il y a eu des erreurs, veuillez consulter le formulaire ci-dessous.';

				// Set errors using custom messages 			
				$errors = $e->errors('models');
			}
		}
	}


	public function action_updateadmin()
	{
		$this->template->content = View::factory('admin/editformadmin')
		    ->bind('nom_site', $nom_site)
			->bind('errors', $errors)
			->bind('username', $username)
			->bind('email', $email)
			->bind('isuser', $isuser)
			->bind('id', $id)
			->bind('message', $message);

		if (HTTP_Request::POST == $this->request->method())
		{
			try {
			    
			    $username=$_POST['username'];
			     $email=$_POST['email'];
			     $isuser=$_POST['isuser'];
			     $id=$_POST['id'];
			     
                $user = ORM::factory('user')
                  ->where('id', '=', $_POST['id'])
                  ->find()->update_user($this->request->post(), array(
                    'username',
					'password',
					'email'
));
			

				// Grant user login role 			
			//	$user->add('roles', ORM::factory('role', array('name' => 'login'//)));

				// Reset values so form is not sticky 				
				$_POST = array();

				// Set success message 			
				$message = "Vous avez modifier l'utilisateur ({$user->username}) .";

			} catch (ORM_Validation_Exception $e) {

				// Set failure message 			
				$message = 'Il y a eu des erreurs, veuillez consulter le formulaire ci-dessous.';

				// Set errors using custom messages 			
				$errors = $e->errors('models');
			}
		}
	}



	public function action_login()
	{
		$this->template->content = View::factory('admin/login')
		    ->bind('nom_site', $nom_site)
			->bind('message', $message);

		if ($_POST)
		{

			// Attempt to login user 		
			$remember = array_key_exists('remember', $this->request->post()) ? (bool) $this->request->post('remember') : FALSE;
			$user = Auth::instance()->login($this->request->post('username'), $this->request->post('password'), $remember);

			// If successful, redirect user 			
			if ($user)
			{
				Request::current()->redirect('user/index');
			}
			else
			{
				$message = 'Échec de la connexion.';
			}
			
		}

		// Load the user information 	
		$user = Auth::instance()->get_user();

		// if a user is not logged in, redirect to login page 		
		if ($user)
		{
			Request::current()->redirect('user');
		}

	}

	public function action_logout()
	{
		// Log user out 		
		Auth::instance()->logout();

		// Redirect to login page 		
		Request::current()->redirect('user/login');
	}

}
?>