<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Welcome extends Controller_Application {
    	public $template = 'template';


	
	public function action_index()
{

$content = View::factory('pages/produits')
->bind('produits', $produits)
->bind('image', $image)
->bind('familles', $familles)
->bind('categories', $categories)
->bind('sous_familles', $sous_familles)
->bind('pager_links', $pager_links)
->bind('famille_actuelle', $famille_actuelle)
->bind('categorie_actuelle', $categorie_actuelle)
->bind('sous_famille_actuelle', $sous_famille_actuelle)
->set('items_per_page', 3);
$content->bind_global('menu_curent', $menu_curent );
		
$menu_curent = 'Accueil';


 
$produits = Model::factory( 'Produit');
$familles = Model::factory( 'Famille');
$sous_familles = Model::factory( 'Sousfamille');
$categories = Model::factory( 'Categorie');

$famille_actuelle= (string) $this->request->param('famille');
$sous_famille_actuelle= (string) $this->request->param('sousfamille');
$categorie_actuelle= (string) $this->request->param('categorie');

$famille_actuelle= str_replace("()","",$famille_actuelle);
$sous_famille_actuelle= str_replace("()","",$sous_famille_actuelle);
$categorie_actuelle= str_replace("()","",$categorie_actuelle);

$message_count = $produits->count_all($categorie_actuelle,$famille_actuelle,$sous_famille_actuelle);
$pagination = Pagination::factory(array(
'total_items' => $message_count,
'items_per_page' =>6,
));

$pager_links = $pagination->render();
$pager_links= str_replace("()","",$pager_links);

$produits = $produits->get_all($categorie_actuelle,$famille_actuelle,$sous_famille_actuelle,$pagination->items_per_page,
$pagination->offset);

$categories = $categories->get_all();

$familles = $familles->get_all($categorie_actuelle);
$sous_familles = $sous_familles->get_all($famille_actuelle);

$this->template->content = $content;
}

} // End Welcome
