<?php defined('SYSPATH') or die('No direct script access.');
/**
* Message Model
* Handles CRUD for user messages
*/
class Model_Article {
// Table name used by this model
protected $_table = 'article';
/**
* Adds a new message for a user
*
* @param string user_id
* @param string user's message
* @return Database
*/

public function add($nom,$text)
{
$values=array($nom, $text);
$data = array('nom','text');
return DB::insert($this->_table, $data)
->values($values)
->execute();


}

public function edit($id,$nom,$text)
{
return  DB::update('article')
->set(array('text' => $text,'nom' => $nom))
->where('id','=',$id)
->execute();
}
/**
* Gets all messages
*
* @return array
* */
public function get_all()
{
return DB::select()
->from($this->_table)
->order_by('id')
->execute()
->as_array();
}


/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function select($id)
{
	 return DB::select()
	->from($this->_table)
	->where('id','=',$id)
	->execute()
	->as_array();
}

public function select_name($nom)
{
	 return DB::select()
	->from($this->_table)
	->where('nom','=',$nom)
	->execute()
	->as_array();
}
/**
* Counts all messages
*
* @return int
*/
}