<?php defined('SYSPATH') or die('No direct script access.');
/**
* Message Model
* Handles CRUD for user messages
*/
class Model_Commande {
// Table name used by this model
protected $_table = 'commande';
/**
* Adds a new message for a user
*
* @param string user_id
* @param string user's message
* @return Database
*/ 
public function add($unite,$id_client,$client,$telephone, $id_product,$product,$quantite,$date_commande)
{
$values=array($unite,$id_client,$client,$telephone, $id_product,$product,$quantite,$date_commande);
$data = array('unite','id_client','client','telephone', 'id_produit','designation','quantite','date_commande');
return DB::insert($this->_table, $data)
->values($values)
->execute();
}
/**
* Gets all messages
*
* @return array
* */
public function get_all($id_client= NULL,$limit = 10, $offset = 0)
{
  if($id_client != '')

  { 
		 return DB::select()
	->from($this->_table)
	->where('id_client','=',$id_client)
	->order_by('date_commande')
	->limit($limit)
	->offset($offset)
	->execute()
	->as_array();
  }else
{
return DB::select()
	->from($this->_table)
	->order_by('date_commande')
	->limit($limit)
	->offset($offset)
	->execute()
	->as_array();
}  
}



/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function delete($id_commande)
{
return DB::delete($this->_table)
->where('id_commande', '=', $id_commande)
->where('valide', '=', 0)
->execute();
}

/**
* Validates a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function valide($id_commande)
{
return DB::update($this->_table)
->set(array('valide' => 1))
->where('id_commande', '=', $id_commande)
->execute();
}

/**
* Devalidates a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function devalide($id_commande)
{
return DB::update($this->_table)
->set(array('valide' => 0))
->where('id_commande', '=', $id_commande)
->execute();
}

/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function select($id)
{
	 return max(DB::select()
	->from($this->_table)
	->where('id','=',$id)
	->execute()
	->as_array());
}

public function get_max_id()
{
	 return DB::select('id_commande')
	->from($this->_table)
	->execute()
	->as_array();
}
/**
* Counts all messages
*
* @return int
*/
public function count_all()
{
return DB::select(DB::expr('COUNT(*) AS message_count'))
->from($this->_table)
->execute()
->get('message_count');
}

/**
* Counts all cmd non valide
*
* @return int
*/
public function count_all_non_valide()
{
return DB::select(DB::expr('COUNT(*) AS message_count'))
->from($this->_table)
->where('valide','=',0)
->execute()
->get('message_count');
}
}