<?php defined('SYSPATH') or die('No direct script access.');
/**
* Message Model
* Handles CRUD for user messages
*/
class Model_Famille {
// Table name used by this model
protected $_table = 'famille';
/**
* Adds a new message for a user
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function add($libelle)
{
$data = array('libelle');
return DB::insert($this->_table, $data)
->values($libelle)
->execute();
}
/**
* Gets all messages
*
* @return array
* */
public function get_all($categorie)
{
return DB::select()
->from($this->_table)
->where('categorie','=',$categorie)
->order_by('libelle')
->execute()
->as_array();
}
/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function delete($libelle)
{
return DB::delete($this->_table)
->where('libelle', '=', $libelle)
->execute();
}
/**
* Counts all messages
*
* @return int
*/
public function count_all()
{
return DB::select(DB::expr('COUNT(*) AS message_count'))
->from($this->_table)
->execute()
->get('message_count');
}
}