<?php defined('SYSPATH') or die('No direct script access.');
/**
* Message Model
* Handles CRUD for user messages
*/
class Model_Lignecommande {
// Table name used by this model
protected $_table = 'ligne_commande';
/**
* Adds a new message for a user
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function add($id_commande,$numero,$id_produit, $libelle,$quantite,$prix)
{
$values=array($id_commande,$numero,$id_produit, $libelle,$quantite,$prix);
$data = array('id_commande','numero','id_produit', 'libelle','quantite','prix');
return DB::insert($this->_table, $data)
->values($values)
->execute();
}
/**
* Gets all messages
*
* @return array
* */
public function get_all($id_commande)
{
  if($id_commande != '')

  { 
		 return DB::select()
	->from($this->_table)
	->where('id_commande','=',$id_commande)
	->order_by('numero')
	->execute()
	->as_array();
  } 
}
/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function delete($id_commande)
{
return DB::delete($this->_table)
->where('id_commande', '=', $id_commande)
->execute();
}

/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function select($id)
{
	 return DB::select()
	->from($this->_table)
	->where('id','=',$id)
	->execute()
	->as_array();
}
/**
* Counts all messages
*
* @return int
*/
public function count_all()
{
return DB::select(DB::expr('COUNT(*) AS message_count'))
->from($this->_table)
->execute()
->get('message_count');
}
}