<?php defined('SYSPATH') or die('No direct script access.');
/**
* Message Model
* Handles CRUD for user messages
*/
class Model_Produit {
// Table name used by this model
protected $_table = 'produit';
/**
* Adds a new message for a user
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function add($libelle,$description,$etat,$unite)
{
$values=array($libelle,$description,$etat,$unite,0);
$data = array('libelle','description','etat','unite','IsService');
return DB::insert($this->_table, $data)
->values($values)
->execute();
}
/**
* Gets all messages
*
* @return array
* */

public function get_alaune($limit = 12)
{

	  return DB::select()
			->from($this->_table)
			->order_by(DB::expr('RAND()'))
			->limit($limit)
			->execute()
			->as_array();
			
}
public function get_promotion()
{

	  return DB::select()
			->from($this->_table)
			->order_by('id')
			->where('promotion','=','1')
			/*->where('etat','=','Disponible')*/
			->execute()
			->as_array();
			
}
public function get_arrivage()
{

	  return DB::select()
			->from($this->_table)
			->order_by('id')			
			->where('etat','=','ARRIVAGE')
			->execute()
			->as_array();
			
}

public function get_all_admin($categorie)
{
  if($categorie != '' )

  { 
		 return DB::select()
	->from($this->_table)
	->where('categorie','=',$categorie)
	->order_by('id')
	->execute()
	->as_array();
  } 
	 else{
	  return DB::select()
			->from($this->_table)
			->order_by('id')
			->execute()
			->as_array();
			}
}

public function get_all($categorie,$limit = 12, $offset = 0)
{
  if($categorie != '' )

  { 
		 return DB::select()
	->from($this->_table)
	->where('categorie','=',$categorie)
	->order_by('id')
	->execute()
	->as_array();
  } 
	 else{
	  return DB::select()
			->from($this->_table)
			->order_by('id')
			->execute()
			->as_array();
			}
}

public function get_all_services($limit, $offset)
{
  if($limit != '' )

  { 
		 return DB::select()
	->from($this->_table)
	->where('IsService','=',TRUE)
	->order_by(DB::expr('RAND()'))
	->limit($limit)
	->offset($offset)
	->execute()
	->as_array();
  } 
	 else{
	  return DB::select()
			->from($this->_table)
			->where('IsService','=',TRUE)
			->order_by('id')
			->execute()
			->as_array();
			}
}

public function get_all_products_unite($unite)
{
 
	  return DB::select()
			->from($this->_table)
			->where('unite','=',$unite)
			->order_by('id')
			->execute()
			->as_array();
			
}

public function get_all_products($limit, $offset)
{
  if($limit != '' )

  { 
		 return DB::select()
	->from($this->_table)
	->where('IsService','=',FALSE)
	->order_by(DB::expr('RAND()'))
	->limit($limit)
	->offset($offset)
	->execute()
	->as_array();
  } 
	 else{
	  return DB::select()
			->from($this->_table)
			->where('IsService','=',TRUE)
			->order_by('id')
			->execute()
			->as_array();
			}
}
/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/

public function edit($id,$libelle,$categorie,$description,$IsService,$unite)
{
return  DB::update('produit')
->set(array('libelle' => $libelle, 'categorie' => $categorie,'description' => $description,'IsService' => $IsService,'unite'=>$unite))
->where('id','=',$id)
->execute();
}

public function delete($id)
{
return DB::delete($this->_table)
->where('id', '=', $id)
->execute();
}

/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function select($id)
{
	 return DB::select()
	->from($this->_table)
	->where('id','=',$id)
	->execute()
	->as_array();
}
/**
* Counts all messages
*
* @return int
*/
public function count_all($categorie)
{
if($categorie != '' )

  { 
			return DB::select(DB::expr('COUNT(*) AS message_count'))
				->from($this->_table)
				->where('categorie','=',$categorie)
				->execute()
				->get('message_count');
  } 
	 else{
	  return DB::select(DB::expr('COUNT(*) AS message_count'))
		->from($this->_table)
		->execute()
		->get('message_count');
			}

}
}