<?php defined('SYSPATH') or die('No direct script access.');
class Model_Slider{
// Table name used by this model
protected $_table = 'slider';
/**
* Adds a new message for a user
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function add($nom,$libelle )
{
$values=array($nom,$libelle);
$data = array('nom','libelle');
return DB::insert($this->_table, $data)
->values($values)
->execute();
}


public function edit($id,$nom,$libelle)
{
return  DB::update('slider')
->set(array('nom' => $nom,'libelle' => $libelle))
->where('id','=',$id)
->execute();
}

/**
* Gets all messages
*
* @return array
* */
public function get_all()
{
return DB::select()
->from($this->_table)
->order_by('id')
->execute()
->as_array();
}

public function select($id)
{
 return DB::select()
	->from($this->_table)
	->where('id','=',$id)
	->execute()
	->as_array();

}
/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function delete($id)
{
return DB::delete($this->_table)
->where('id', '=', $id)
->execute();
}
/**
* Counts all messages
*
* @return int
*/
public function count_all()
{
return DB::select(DB::expr('COUNT(*) AS message_count'))
->from($this->_table)
->execute()
->get('message_count');
}
}