<?php defined('SYSPATH') or die('No direct script access.');
/**
* Message Model
* Handles CRUD for user messages
*/
class Model_Sousfamille {
// Table name used by this model
protected $_table = 'sous_famille';
/**
* Adds a new message for a user
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function add($famille_mere,$libelle)
{
$data = array('famille_mere','libelle');
return DB::insert($this->_table, $data)
->values($famille_mere,$libelle)
->execute();
}
/**
* Gets all messages
*
* @return array
* */
public function get_all($famille_mere)
{
return DB::select()
->from($this->_table)
->where('famille_mere','=',$famille_mere)
->order_by('libelle')
->execute()
->as_array();
}
/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function delete($libelle)
{
return DB::delete($this->_table)
->where('libelle', '=', $libelle)
->execute();
}
/**
* Counts all messages
*
* @return int
*/
public function count_all()
{
return DB::select(DB::expr('COUNT(*) AS message_count'))
->from($this->_table)
->execute()
->get('message_count');
}
}