
<?php defined('SYSPATH') or die('No direct script access.');
/**
* Message Model
* Handles CRUD for user messages
*/
class Model_User extends Model_Auth_User{
// Table name used by this model
protected $_table = 'users';
/**
* Adds a new message for a user
*
* @param string user_id
* @param string user's message
* @return Database
*
public function add($email,$username,$raison_sociale,$telephone,$nom_contact,$adresse,$password,$isuser=0,$iscommercial=0)
{
$values = array($email,$username,$raison_sociale,$telephone,$nom_contact,$adresse,$password,$isuser,$iscommercial);
$data = array('email','username','raison_sociale','telephone','nom_contact','adresse','password','isuser','iscommercial');
return DB::insert($this->_table, $data)
->values($values)
->execute();
}

public function edit($id,$email,$username,$raison_sociale,$telephone,$nom_contact,$adresse,$password,$isuser=0,$iscommercial=0)
{
return  DB::update($this->_table)
->set(array('email'=>$email,
             'username'=>$username,
			 'raison_sociale'=>$raison_sociale,
			 'telephone'=>$telephone,
			 'nom_contact'=>$nom_contact,
			 'adresse'=>$adresse,
			 'password'=>$password,
			 'isuser'=>$isuser,
			 'iscommercial'=>$iscommercial))
->where('id','=',$id)
->execute();
}


/**
* Gets all messages
*
* @return array
* */
public function get_all($limit = 10, $offset = 0)
{
	  return DB::select()
			->from($this->_table)
			->where('isuser', '=', 0)
			->order_by('raison_sociale')
			->execute()
			->as_array();
			}


public function get_all_admin($limit = 10, $offset = 0)
{
	 return DB::select()
			->from($this->_table)
			->where('isuser', '=', 1)
			->order_by('raison_sociale')
			->execute()
			->as_array();
			}

/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*
public function delete($id)
{
return DB::delete($this->_table)
->where('id', '=', $id)
->execute();
}

/**
* Deletes a message from the DB
*
* @param string user_id
* @param string user's message
* @return Database
*/
public function select($id)
{
	 return DB::select()
	->from($this->_table)
	->where('id','=',$id)
	->execute()
	->as_array();
}

public function select_user_password($user, $password)
{
	 return DB::select()
	->from($this->_table)
	->where('username','=',$user)
	->where('password','=',$password)
	->execute()
	->as_array();
}
/**
* Login application mobile all messages
*
* @return int
*/

 public function _login($user, $password)
 {
      if ( ! is_object($user))
     {
         $username = $user;
 
       // Load the user
         $user  = Model::factory('User');
         $user=$user->select_user_password($username,$password);
    
  foreach ($user as $users) : 
    //If the passwords match, perform a login
		//	$user->logins = new Database_Expression('logins + 1');

			//Set the last login date
		//	 $user->last_login = time();

			//Save the user
			// $user->update();
						// */
         return TRUE;
     //}
  endforeach; 
   // Login failed
     return FALSE;
 }
 
 }




/**
* Counts all messages
*
* @return int
*/

// public function _login($user, $password)
// {
    // if ( ! is_object($user))
    // {
        // $username = $user;
 
       // Load the user
        // $user  = Model::factory('User');
        // $user=$user->select($username);
    // }
 // foreach ($user as $users) : 
    //If the passwords match, perform a login
    // if ($users['password'] == $password)
    // {
	// /*
			// $user->logins = new Database_Expression('logins + 1');

			//Set the last login date
			// $user->last_login = time();

			//Save the user
			// $user->update();
						// */
        // return TRUE;
    // }
 // endforeach; 
   // Login failed
    // return FALSE;
// }
public function count_all()
{
return DB::select(DB::expr('COUNT(*) AS message_count'))
->from($this->_table)
->execute()
->get('message_count');
}


}